// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

#ifndef ARRAY_H
#define ARRAY_H

#include "degub.h"
#include <crtdbg.h>
#include <stdlib.h>
#include <search.h>

//extern int array_new_id, array_break_id;
#define ARRAY_MAX_SIZE 100*M	//100 MegaBytes
#define ARRAY_CHECK_SIZE if(size > ARRAY_MAX_SIZE)\
	throw generic_fatal_exception("Array size: " + size)

template<class T> class Array {
public:
	Array(size_t size) {
		allocate(size);
		g_arr_num++;
		if(g_arr_num > g_arr_num_max)
			g_arr_num_max = g_arr_num;
	}
	Array(size_t size, const T *data) {
		allocate(size);
		for(size_t i=0; i<size; i++) {
			a[i] = data[i];
		}
		g_arr_num++;
		if(g_arr_num > g_arr_num_max)
			g_arr_num_max = g_arr_num;
	}
	~Array() {
		g_con_total -= b * sizeof(T);
		delete[] a;
		g_arr_num--;
	}
	void resize(size_t size) {
		if(b == size)
			return;
		g_con_total -= b * sizeof(T);
		delete[] a;
		allocate(size);
	}

	T& operator[](size_t index) {
		MYASSERT(index < b);
		return a[index];
	}

	const T& operator[](size_t index) const {
		MYASSERT(index < b);
		return a[index];
	}

	const T* p() const { return a; }
	T* p() { return a; }
	size_t size() const { return b; }
	void sort(int (__cdecl *compare)(const void *, const void *)) {
		qsort(a, b, sizeof(T), compare);
	}
	void steal(Array<T> &src) {
		resize(0); a = src.a; b = src.b;
		src.a = NULL; src.b = 0;
	}
	void swap(Array<T> &other) {
		T *ta = a; size_t tb = b;
		a = other.a; b = other.b;
		other.a = ta; other.b = tb;
	}
private:
	Array(const Array&);
	Array &operator=(const Array&);
	T *a;
	size_t b;

	void allocate(size_t size) {
		ARRAY_CHECK_SIZE;

		g_con_total += size * sizeof(T);
		if(g_con_total > g_con_maximum)
			g_con_maximum = g_con_total;
		//if(size > 1000*K) {
		//DEGUB("Megabyte Array!\n");
		//}
		b = size;
		if(size == 0)
			a = NULL;
		else {
			a = new T[size];
			if(a == NULL)
				BFE("new[] failed in Array");
		}
	}
};

bool all_true(const Array<bool> &arr);

#endif	//ARRAY_H
